-- Level Defines
require("scripts/basicSetting.lua")

-- Guest Types List
GuestTypeList = nil;
GuestTypeList =
{
	female01,
	female02,
	female03,
	female04,
	male01,
	male02,
	male03,
	male04,
	uncle,
	aunt
}

-- Default Guest Definitions
GuestDefinitionList = nil;
GuestDefinitionList =
{
	{
		type = female01,					
		tolerance = 45000,
		waitBeforeSit = 2000,
		waitBeforeGift = 1000,
		waitBeforeAppetizer = 1000,
		waitBeforeDinner = 14000,
		waitBeforeCake = 16000,
		percentRequestDrink = 0,
		percentRequestMusic = 0,
		percentRequestResit = 10,
		likes = {female03, female04, male01, male02, male03, male04, aunt},
		dislikes = {female01, female02, uncle}
	},
	{

		type = female02,
		tolerance = 45000,
		waitBeforeSit = 2000,
		waitBeforeGift = 1000,
		waitBeforeAppetizer = 1000,
		waitBeforeDinner = 14000,
		waitBeforeCake = 16000,
		percentRequestDrink = 0,
		percentRequestMusic = 0,
		percentRequestResit = 10,
		likes = {female01, female03, female04, male01, male02, male03, aunt, male04},
		dislikes = {female02, uncle}


	},
	{
		type = female03,
		tolerance = 45000,
		waitBeforeSit = 2000,
		waitBeforeGift = 1000,
		waitBeforeAppetizer = 1000,
		waitBeforeDinner = 14000,
		waitBeforeCake = 16000,
		percentRequestDrink = 0,
		percentRequestMusic = 0,
		percentRequestResit = 10,
		likes = {female01, female04, male01, male02, male03, aunt, male04},
		dislikes = {female02, female03, uncle}

	},
	{
		type = female04,
		tolerance = 60000,
		waitBeforeSit = 2000,
		waitBeforeGift = 1000,
		waitBeforeAppetizer = 1000,
		waitBeforeDinner = 20000,
		waitBeforeCake = 24000,
		percentRequestDrink = 0,
		percentRequestMusic = 0,
		percentRequestResit = 10,
		likes = {female01, female03, male01, male02, male03, aunt, male04},
		dislikes = {female02, female04, uncle}

	},
	{
		type = male01,
		tolerance = 45000,
		waitBeforeSit = 2000,
		waitBeforeGift = 1000,
		waitBeforeAppetizer = 1000,
		waitBeforeDinner = 7000,
		waitBeforeCake = 8000,
		percentRequestDrink = 0,
		percentRequestMusic = 0,
		percentRequestResit = 10,
		likes = {female01, female03, female04, male02, male03, aunt, male04},
		dislikes = {female02, male01, uncle}
	
	},
	{	type = male02,
		tolerance = 45000,
		waitBeforeSit = 2000,
		waitBeforeGift = 1000,
		waitBeforeAppetizer = 1000,
		waitBeforeDinner = 3000,
		waitBeforeCake = 3000,
		percentRequestDrink = 0,
		percentRequestMusic = 0,
		percentRequestResit = 10,
		likes = {female01, female03, female04, male01, male03, aunt, male04},
		dislikes = {female02, male02, uncle}

	},
	{
		type = male03,
		tolerance = 30000,
		waitBeforeSit = 2000,
		waitBeforeGift = 1000,
		waitBeforeAppetizer = 1000,
		waitBeforeDinner = 7000,
		waitBeforeCake = 8000,
		percentRequestDrink = 0,
		percentRequestMusic = 0,
		percentRequestResit = 10,
		likes = {female01, female03, female04, male01, male02, aunt, male04},
		dislikes = {female02, male03, uncle}

	},
	{
		type = male04,
		tolerance = 45000,
		waitBeforeSit = 2000,
		waitBeforeGift = 1000,
		waitBeforeAppetizer = 1000,
		waitBeforeDinner = 14000,
		waitBeforeCake = 16000,
		percentRequestDrink = 0,
		percentRequestMusic = 0,
		percentRequestResit = 10,
		likes = {female01, female03, female04, male01, male02, male03, aunt},
		dislikes = {female02, male02, uncle}

	},
	{
		type = uncle,
		tolerance = 30000,
		waitBeforeSit = 2000,
		waitBeforeGift = 1000,
		waitBeforeAppetizer = 1000,
		waitBeforeDinner = 14000,
		waitBeforeCake = 16000,
		percentRequestDrink = 0,
		percentRequestMusic = 0,
		percentRequestResit = 0,
		percentRequestCoffee = 10,
		likes = {female01, female03, female04, male01, male02, male03, aunt, male04},
		dislikes = {female02, uncle}

	},
	{
		type = aunt,
		tolerance = 45000,
		waitBeforeSit = 2000,
		waitBeforeGift = 1000,
		waitBeforeAppetizer = 1000,
		waitBeforeDinner = 14000,
		waitBeforeCake = 16000,
		percentRequestDrink = 0,
		percentRequestMusic = 0,
		percentRequestResit = 0,
		percentRequestTissue = 10,
		likes = {female01, female03, female04, male01, male02, male03, male04, uncle},
		dislikes = {female02, aunt}
	}
}

-- Default Level Settings
DefaultLevel = nil;
DefaultLevel = 
{
	map=0,
	level=0,
	introBG="assets/images/intro/intro_bg",
	introBG2="assets/images/intro/intro_bg02",
	chair_image = "images/table/chair";
	slowMusic="",
	fastMusic="",
	fastMusic2="",
	blaster=0,						-- include the confetti blaster on this level? 1 means yes.
	totalTime=400000,				-- Total time for this level
	matchGameDelay=9999000,			-- time before the first match game (and delay between each next attempt)
	matchGameLength=9999000,		-- time for a Quinn match game to last
	patienceBonusTime=40000,		-- bonus time for a guest after completing a request
	patiencePenaltyTime=1000,  		-- penalty time for a guest if not completing a request
	matchRequestTime=10000,			-- the time for a match request to last
	drinkRequestTime=15000,			-- the time for a drink request to last
	musicRequestTime=15000,			-- the time for a music request to last
	coffeeRequestTime=15000,		-- the time for a coffee request to last
	tissueRequestTime=15000,		-- the time for a tissue request to last
	waitressMaxQueue = 6,			-- max queued actions for a waitress
	requestAppearTime = 3000,		-- the bouncy icon for a request appear time
	specialAppearTime = 9000,		-- the bouncy icon for a special request appear time
	passScore = 1000,				-- pass score to next level
	highScore = 2000,				-- score to achieve master status
	needMatchBeforeDance="no",		-- enable matching dance
	lastRequest = cake,				-- last request of a guest. (must be appetizer, dinner, cake, or gift)
	percentDog = 0,					-- Percent chance that a dog will appear
	bridesmaidsDelay = 9999000,		-- after this much time there is a chance for the bridesmaids to appear (re-occuring)
	bridesmaidsChance = 0,			-- the chance that the bridesmaids will apepar	
	bridesmaidsUseDog = 0,			-- uses the dog instead of the bridesmaids for this level (same functionality)
	percentSpeaker = 0,				-- Percent chance that the speaker will become unplugged
	cakeTipDelay = 9999000,			-- after this much time there is a chance for the cake to tip (re-occuring)
	cakeTipChance = 0,				-- the chance that the cake will tip	
	guestRequestTablePercent=0,		-- percentage for a guest to request to sit in a particular table
	seatingDifficultyLevel=0		-- difficulty of the seating puzzle
}